/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.client.gui.screens;

import dev.lucaargolo.charta.Charta;
import dev.lucaargolo.charta.client.gui.components.CardWidget;
import dev.lucaargolo.charta.client.gui.screens.CardScreen;
import dev.lucaargolo.charta.game.Card;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.Suit;
import dev.lucaargolo.charta.menu.CardSlot;
import dev.lucaargolo.charta.utils.ChartaGuiGraphics;
import dev.lucaargolo.charta.utils.HoverableRenderable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeckScreen
extends CardScreen
implements HoverableRenderable {
    private final class_437 parent;
    private final CardDeck deck;
    private final Set<Suit> suits;
    private int headerOffset = 10;
    private int footerOffset = 10;

    public DeckScreen(@Nullable class_437 parent, CardDeck deck) {
        super(deck.getName());
        this.parent = parent;
        this.deck = deck;
        this.suits = this.deck.getCards().stream().map(Card::getSuit).collect(Collectors.toSet());
    }

    protected void method_25426() {
        if (this.parent != null) {
            class_5250 back = class_2561.method_43470((String)"\ue5c4").method_27696(Charta.SYMBOLS);
            this.method_37063((class_364)new class_4185.class_7840((class_2561)back, b -> this.method_25419()).method_46434(5, 5, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.charta.go_back"))).method_46431());
        }
        float cardWidth = CardSlot.getWidth(CardSlot.Type.DEFAULT);
        float maxWidth = (float)this.field_22789 - 60.0f - cardWidth;
        float maxLeftOffset = cardWidth + cardWidth / 10.0f;
        float maxHeight = (float)this.field_22790 - 80.0f;
        float cardHeight = CardSlot.getHeight(CardSlot.Type.DEFAULT);
        float maxTopOffset = cardHeight + cardHeight / 10.0f;
        float topOffset = cardHeight + Math.max(0.0f, maxHeight - (float)this.suits.size() * cardHeight / (float)this.suits.size());
        float totalHeight = cardHeight + topOffset * ((float)this.suits.size() - 1.0f);
        float topExcess = totalHeight - maxHeight;
        if (topExcess > 0.0f) {
            topOffset -= topExcess / ((float)this.suits.size() - 1.0f);
        }
        totalHeight = cardHeight + maxTopOffset * ((float)this.suits.size() - 1.0f);
        float top = 0.0f;
        if (topOffset > maxTopOffset) {
            top = Math.max(topOffset - maxTopOffset, maxHeight - totalHeight);
            topOffset = maxTopOffset;
        }
        this.headerOffset = Math.max(0, class_3532.method_15375((float)(top / 2.0f + 15.0f)));
        this.footerOffset = Math.max(0, class_3532.method_15375((float)(top / 2.0f + 27.0f)));
        int i = 0;
        for (Suit suit : this.suits) {
            List<Card> cards = this.deck.getCards().stream().filter(c -> c.getSuit().equals((Object)suit)).sorted().toList();
            float leftOffset = cardWidth + Math.max(0.0f, maxWidth - (float)cards.size() * cardWidth / (float)cards.size());
            float totalWidth = cardWidth + leftOffset * ((float)cards.size() - 1.0f);
            float leftExcess = totalWidth - maxWidth;
            if (leftExcess > 0.0f) {
                leftOffset -= leftExcess / ((float)cards.size() - 1.0f);
            }
            totalWidth = cardWidth + maxLeftOffset * ((float)cards.size() - 1.0f);
            float left = 0.0f;
            if (leftOffset > maxLeftOffset) {
                left = Math.max(leftOffset - maxLeftOffset, maxWidth - totalWidth);
                leftOffset = maxLeftOffset;
            }
            this.method_37063((class_364)new CardWidget(this, Card.BLANK, this.deck, 25.0f + left / 2.0f, 45.0f + topOffset * (float)i + top / 2.0f, 1.0f){

                @Override
                @Nullable
                public String getCardTranslatableKey() {
                    return DeckScreen.this.deck.getDeckTranslatableKey();
                }
            });
            int j = 0;
            for (Card card : cards) {
                CardWidget cardWidget = new CardWidget(this, card, this.deck, cardWidth + 35.0f + leftOffset * (float)j + left / 2.0f, 45.0f + topOffset * (float)i + top / 2.0f, 1.0f);
                this.method_37063((class_364)cardWidget);
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void renderFg(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.headerOffset, -1);
        int i = 0;
        int totalWidth = this.suits.size() * 16 - 3;
        for (Suit suit : this.suits) {
            ChartaGuiGraphics.blitSuitAndGlow(guiGraphics, this.deck, suit, (float)this.field_22789 / 2.0f - (float)totalWidth / 2.0f + (float)(i * 16), this.headerOffset + 10, 0.0f, 0.0f, 13.0f, 13.0f, 13.0f, 13.0f);
            ++i;
        }
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)(this.deck.getCards().size() + " ")).method_10852((class_2561)class_2561.method_43471((String)"charta.cards")).method_27693(" | " + this.suits.size() + " ").method_10852((class_2561)class_2561.method_43471((String)"charta.suits")), this.field_22789 / 2, this.field_22790 - this.footerOffset, -1);
    }

    @Override
    public void scheduleTooltip(class_2561 component) {
        this.method_47415(component);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

